#!/usr/bin/env python




##################################################
## DEPENDENCIES
import sys
import os
import os.path
try:
    import builtins as builtin
except ImportError:
    import __builtin__ as builtin
from os.path import getmtime, exists
import time
import types
from Cheetah.Version import MinCompatibleVersion as RequiredCheetahVersion
from Cheetah.Version import MinCompatibleVersionTuple as RequiredCheetahVersionTuple
from Cheetah.Template import Template
from Cheetah.DummyTransaction import *
from Cheetah.NameMapper import NotFound, valueForName, valueFromSearchList, valueFromFrameOrSearchList
from Cheetah.CacheRegion import CacheRegion
import Cheetah.Filters as Filters
import Cheetah.ErrorCatchers as ErrorCatchers
import six
from six.moves.urllib.parse import quote
from Plugins.Extensions.OpenWebif.controllers.i18n import tstrings
from json import dumps
from time import localtime, strftime, mktime
from Plugins.Extensions.OpenWebif.controllers.views.ajax.renderevtblock import renderEvtBlock

##################################################
## MODULE CONSTANTS
VFFSL=valueFromFrameOrSearchList
VFSL=valueFromSearchList
VFN=valueForName
currentTime=time.time
__CHEETAH_version__ = '2.4.4'
__CHEETAH_versionTuple__ = (2, 4, 4, 'development', 0)
__CHEETAH_genTime__ = 1644610942.847142
__CHEETAH_genTimestamp__ = 'Fri Feb 11 20:22:22 2022'
__CHEETAH_src__ = '/home/nonsolosat/openpli-dreambox-oe-core/build/tmp/work/dm7080-oe-linux/enigma2-plugin-extensions-openwebif/gitAUTOINC+81b15e17ab-r0/git/plugin/controllers/views/ajax/multiepg.tmpl'
__CHEETAH_srcLastModified__ = 'Fri Feb 11 20:05:52 2022'
__CHEETAH_docstring__ = 'Autogenerated by Cheetah: The Python-Powered Template Engine'

if __CHEETAH_versionTuple__ < RequiredCheetahVersionTuple:
    raise AssertionError(
      'This template was compiled with Cheetah version'
      ' %s. Templates compiled before version %s must be recompiled.'%(
         __CHEETAH_version__, RequiredCheetahVersion))

##################################################
## CLASSES

class multiepg(Template):

    ##################################################
    ## CHEETAH GENERATED METHODS


    def __init__(self, *args, **KWs):

        super(multiepg, self).__init__(*args, **KWs)
        if not self._CHEETAH__instanceInitialized:
            cheetahKWArgs = {}
            allowedKWs = 'searchList namespaces filter filtersLib errorCatcher'.split()
            for k,v in KWs.items():
                if k in allowedKWs: cheetahKWArgs[k] = v
            self._initCheetahInstance(**cheetahKWArgs)
        

    def respond(self, trans=None):



        ## CHEETAH: main method generated for this template
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        write(u'''<style>
\ttable { font-family: Verdana; font-size: 11px; }
\ttr { vertical-align: top }
\t.float { float:left }
\t.service { font-weight: bold; font-size: 12px; line-height:30px; padding-right: 4px; white-space: nowrap; overflow: hidden;}
\t.service img { width:50px; height:30px; float:left; margin-right:10px; border: 0;}
\t.title { font-weight: bold;}
\t.desc { font-size: 10px; line-height: 1.25em; max-height: 3.75em; overflow: hidden; }
\t.event { cursor: pointer; width: 190px; overflow:hidden; margin-bottom: 0.75em;}
\t.bq { font-size: 11px; font-weight: bold; padding: 2px 4px; line-height: 18px; cursor: pointer; white-space: nowrap; display: inline-block; margin: 1px 1px 0px 0px;}
\t.plus { font-size: 13px; font-weight: bold; padding: 2px 4px; line-height: 21px; cursor: pointer; white-space: nowrap; }
\t.timer { font-weight: bold; font-size: 10px; }
\t#eventdescription { width: 375px; height: auto; position: fixed; top: 205px; left: 350px; z-index: 100; display: none; overflow: auto; }
\t#navepg { margin-bottom: 1px; }
\t#tbl1 thead tr, #tbl1 tfoot tr { display: block; width: 100%; }
\t#tbl1 tbody { width: 100%; height: 100%; overflow-y: auto; display: block; overflow-x: hidden;}
\t.ui-widget-content.nobg , .ui-widget-header.nobg{ background-image: none; } 
\t.wrapper { overflow-x: auto; width: 100%; -ms-overflow-style: -ms-autohiding-scrollbar;}
\ttd.border { width: 190px; }
\t.plus.ui-state-default.lbl { border:none; background:none; cursor:default; color:inherit;}
\t.wrapper::-webkit-scrollbar { width: 12px; }
\t#tblinner::-webkit-scrollbar { width: 8px; }
\t::-webkit-scrollbar-track { background: #f1f1f1; }
\t::-webkit-scrollbar-thumb { background: #6784b3; }
</style>

<div id="navepg">
''')
        for slot in list(range(0,7)): # generated from line 34, col 1
            write(u'''\t<div class="float plus ui-state-default ''')
            if VFFSL(SL,"slot",True)==VFFSL(SL,"day",True) : # generated from line 35, col 42
                _v =  'ui-state-active' 
                if _v is not None: write(_filter(_v))
            else:
                _v =  '' 
                if _v is not None: write(_filter(_v))
            write(u'''" data-day="''')
            _v = VFFSL(SL,"slot",True) # u'$(slot)' on line 35, col 102
            if _v is not None: write(_filter(_v, rawExpr=u'$(slot)')) # from line 35, col 102.
            write(u'''">''')
            _v = VFFSL(SL,"tstrings",True)[("day_" + (time.strftime("%w", time.localtime(time.time()+86400*slot))))] # u'$tstrings[("day_" + (time.strftime("%w", time.localtime(time.time()+86400*slot))))]' on line 35, col 111
            if _v is not None: write(_filter(_v, rawExpr=u'$tstrings[("day_" + (time.strftime("%w", time.localtime(time.time()+86400*slot))))]')) # from line 35, col 111.
            write(u'''</div>
''')
        if VFFSL(SL,"mode",True) == 2: # generated from line 37, col 1
            write(u'''<div class="float plus ui-state-default lbl">&nbsp;''')
            _v = VFFSL(SL,"tstrings",True)['prime_times'] # u"$tstrings['prime_times']" on line 38, col 52
            if _v is not None: write(_filter(_v, rawExpr=u"$tstrings['prime_times']")) # from line 38, col 52.
            write(u''':&nbsp;</div>
<div id="pt0" class="float plus ui-state-default" data-day="201">06:00</div>
<div id="pt1" class="float plus ui-state-default" data-day="202">12:00</div>
<div id="pt2" class="float plus ui-state-default" data-day="203">20:00</div>
''')
            if VFFSL(SL,"day",True) == 0: # generated from line 42, col 1
                write(u'''<div id="pt3" class="float">&nbsp;</div>
<div id="pt4" class="float plus ui-state-default" data-day="200">''')
                _v = VFFSL(SL,"tstrings",True)['now'] # u"$tstrings['now']" on line 44, col 66
                if _v is not None: write(_filter(_v, rawExpr=u"$tstrings['now']")) # from line 44, col 66.
                write(u'''</div>
''')
        else: # generated from line 46, col 1
            write(u'''<div class="float plus ui-state-default lbl">&nbsp;''')
            _v = VFFSL(SL,"tstrings",True)['cw'] # u"$tstrings['cw']" on line 47, col 52
            if _v is not None: write(_filter(_v, rawExpr=u"$tstrings['cw']")) # from line 47, col 52.
            write(u''':&nbsp;</div>
''')
            for wk in list(range(0,3)): # generated from line 48, col 1
                w = VFFSL(SL,"wk",True) + 1000
                write(u'''\t<div class="float plus ui-state-default ''')
                if VFFSL(SL,"wk",True)==VFFSL(SL,"week",True) : # generated from line 50, col 42
                    _v =  'ui-state-active' 
                    if _v is not None: write(_filter(_v))
                else:
                    _v =  '' 
                    if _v is not None: write(_filter(_v))
                write(u'''" data-day="''')
                _v = VFFSL(SL,"w",True) # u'$(w)' on line 50, col 101
                if _v is not None: write(_filter(_v, rawExpr=u'$(w)')) # from line 50, col 101.
                write(u'''">''')
                _v = VFN(VFFSL(SL,"time",True),"strftime",False)("%V",time.localtime(time.time()+604800*wk)) # u'$time.strftime("%V",time.localtime(time.time()+604800*wk))' on line 50, col 107
                if _v is not None: write(_filter(_v, rawExpr=u'$time.strftime("%V",time.localtime(time.time()+604800*wk))')) # from line 50, col 107.
                write(u'''</div>
''')
        write(u'''<div class="float plus ui-state-default lbl">&nbsp;''')
        _v = VFFSL(SL,"tstrings",True)['display_mode'] # u"$tstrings['display_mode']" on line 53, col 52
        if _v is not None: write(_filter(_v, rawExpr=u"$tstrings['display_mode']")) # from line 53, col 52.
        write(u''':&nbsp;</div>
<div class="float plus ui-state-default ''')
        if VFFSL(SL,"mode",True)==1 : # generated from line 54, col 41
            _v =  'ui-state-active' 
            if _v is not None: write(_filter(_v))
        else:
            _v =  '' 
            if _v is not None: write(_filter(_v))
        write(u'''" data-day="101">''')
        _v = VFFSL(SL,"tstrings",True)['tv_guide'] # u"$tstrings['tv_guide']" on line 54, col 103
        if _v is not None: write(_filter(_v, rawExpr=u"$tstrings['tv_guide']")) # from line 54, col 103.
        write(u'''</div>
<div class="float plus ui-state-default ''')
        if VFFSL(SL,"mode",True)==2 : # generated from line 55, col 41
            _v =  'ui-state-active' 
            if _v is not None: write(_filter(_v))
        else:
            _v =  '' 
            if _v is not None: write(_filter(_v))
        write(u'''" data-day="102">''')
        _v = VFFSL(SL,"tstrings",True)['timeline'] # u"$tstrings['timeline']" on line 55, col 103
        if _v is not None: write(_filter(_v, rawExpr=u"$tstrings['timeline']")) # from line 55, col 103.
        write(u'''</div>
''')
        if VFFSL(SL,"mode",True) == 1: # generated from line 56, col 1
            write(u'''<div class="float plus ui-state-default lbl">&nbsp;''')
            _v = VFFSL(SL,"tstrings",True)['date'] # u"$tstrings['date']" on line 57, col 52
            if _v is not None: write(_filter(_v, rawExpr=u"$tstrings['date']")) # from line 57, col 52.
            write(u''':&nbsp;''')
            _v = VFN(VFFSL(SL,"time",True),"strftime",False)("%x", time.localtime(time.time()+86400*VFFSL(SL,"day",True)+604800*VFFSL(SL,"week",True))) # u'$time.strftime("%x", time.localtime(time.time()+86400*$day+604800*$week))' on line 57, col 76
            if _v is not None: write(_filter(_v, rawExpr=u'$time.strftime("%x", time.localtime(time.time()+86400*$day+604800*$week))')) # from line 57, col 76.
            write(u'''</div>
''')
        write(u'''<div id="compressmepg" onclick="CompressMEPG();"><i id="compressmepgi" class="fa fa-compress link" aria-hidden="true"></i></div>
<div id="refreshmepg2" onclick="RefreshMEPG();"><i id="refreshmepgi" class="fa fa-refresh link" aria-hidden="true"></i></div>
\t<br clear="all">

''')
        for bq in VFFSL(SL,"bouquets",True): # generated from line 63, col 1
            write(u'''\t<div class="float bq ui-state-default ''')
            if VFFSL(SL,"bq",True)[0]==VFFSL(SL,"bref",True) : # generated from line 64, col 40
                _v =  'ui-state-active' 
                if _v is not None: write(_filter(_v))
            else:
                _v =  '' 
                if _v is not None: write(_filter(_v))
            write(u'''" data-ref="''')
            _v = VFFSL(SL,"quote",False)(VFFSL(SL,"bq",True)[0]) # u'$quote($bq[0])' on line 64, col 102
            if _v is not None: write(_filter(_v, rawExpr=u'$quote($bq[0])')) # from line 64, col 102.
            write(u'''">''')
            _v = VFFSL(SL,"bq",True)[1] # u'$bq[1]' on line 64, col 118
            if _v is not None: write(_filter(_v, rawExpr=u'$bq[1]')) # from line 64, col 118.
            write(u'''</div>
''')
        write(u'''<br clear="all">
</div>

''')
        if VFFSL(SL,"mode",True) == 2: # generated from line 69, col 1
            write(u'''
<style>
.picon { display: inline-block; margin:0; max-width: 100px;}
.picon > img { max-height: 30px;}

.eventlist { display: inline-block; list-style-type: none; margin: 0px; padding: 1px 0px; width: calc(100% - 105px); }
.event { display: block; position: relative; vertical-align: top; clear: left; border: none; }
.event a,.event > span { padding: 0 0 0 10px; height:48px; width:100%; display: block; white-space: normal; overflow: hidden; }
.event a:link:hover { text-decoration: none; }
.ename { display: block; width: 100%; float: left; font-weight: 200; line-height: 1,4; font-size: 14px; }
.etime,.etimer  { display: inline-block; padding-right: 20px; font-weight: 200; line-height: 1,4; font-size: 12px; }
.event { display: inline-block; border-width: 0px 0px 0px 1px; }
.event .ename,.event .etime,.event .etimer { white-space: nowrap; overflow: hidden; text-overflow: ellipsis; }
</style>

''')
            now = VFFSL(SL,"mktime",False)(VFFSL(SL,"localtime",False)())
            write(u'''
''')
            if VFFSL(SL,"day",True) == 0: # generated from line 87, col 1
                first = VFFSL(SL,"now",True) - 3600
            else: # generated from line 89, col 1
                first = VFFSL(SL,"now",True) + (VFFSL(SL,"day",True) * 3600 * 24)
            write(u'''
''')
            s = VFFSL(SL,"strftime",False)("%S",VFFSL(SL,"localtime",False)(VFFSL(SL,"first",True)))
            m = VFFSL(SL,"strftime",False)("%M",VFFSL(SL,"localtime",False)(VFFSL(SL,"first",True)))
            offset = VFFSL(SL,"int",False)(VFFSL(SL,"m",True)) * 60
            offset = VFFSL(SL,"offset",True) + VFFSL(SL,"int",False)(VFFSL(SL,"s",True))
            write(u'''
''')
            if VFFSL(SL,"day",True) > 0: # generated from line 98, col 1
                h = VFFSL(SL,"strftime",False)("%H",VFFSL(SL,"localtime",False)(VFFSL(SL,"first",True)))
                offset = VFFSL(SL,"offset",True) + VFFSL(SL,"int",False)(VFFSL(SL,"h",True)) * 60 * 60
                offset = VFFSL(SL,"offset",True) + 3600
            write(u'''
''')
            first = VFFSL(SL,"first",True) - VFFSL(SL,"offset",True)
            write(u'''
''')
        write(u'''
''')
        if VFFSL(SL,"mode",True) == 1: # generated from line 108, col 1
            renderEventBlock = VFFSL(SL,"renderEvtBlock",False)()
            write(u'''<div class="wrapper">
<table border="0" cellpadding="0" cellspacing="0" width="100%" id="tbl1">
<thead>
<tr>
''')
            for sname, eventlist in six.iteritems(VFFSL(SL,"events",True)): # generated from line 114, col 2
                evl = VFFSL(SL,"eventlist",True)[0]
                ref = ""
                if VFFSL(SL,"evl",True): # generated from line 117, col 2
                    ev = VFFSL(SL,"evl",True)[0]
                    ref = "data-ref='" + VFFSL(SL,"ev.ref",True) + "'"
                write(u'''\t<td class="border"><div class="service ui-widget-header" ''')
                _v = VFFSL(SL,"ref",True) # u'$ref' on line 121, col 59
                if _v is not None: write(_filter(_v, rawExpr=u'$ref')) # from line 121, col 59.
                write(u'''><img src="''')
                _v = VFFSL(SL,"picons",True)[VFFSL(SL,"sname",True)] # u'$(picons[$sname])' on line 121, col 74
                if _v is not None: write(_filter(_v, rawExpr=u'$(picons[$sname])')) # from line 121, col 74.
                write(u'''" /> ''')
                _v = VFFSL(SL,"sname",True) # u'$sname' on line 121, col 96
                if _v is not None: write(_filter(_v, rawExpr=u'$sname')) # from line 121, col 96.
                write(u'''</div></td>
''')
            write(u'''</tr>
</thead>
<tbody id="tbl1body">
''')
            for slot in list(range(0,12)): # generated from line 126, col 2
                write(u'''\t<tr class="''')
                _v = VFFSL(SL,"slot",True)%2 and 'ui-widget-content' or 'ui-widget-content ui-state-hover' # u"$(slot%2 and 'ui-widget-content' or 'ui-widget-content ui-state-hover')" on line 127, col 13
                if _v is not None: write(_filter(_v, rawExpr=u"$(slot%2 and 'ui-widget-content' or 'ui-widget-content ui-state-hover')")) # from line 127, col 13.
                write(u''' nobg">
''')
                for sname, eventlist in six.iteritems(VFFSL(SL,"events",True)): # generated from line 128, col 3
                    write(u'''\t\t<td class="border">
''')
                    for event in VFFSL(SL,"eventlist",True)[VFFSL(SL,"slot",True)]: # generated from line 130, col 4
                        write(u'''\t\t\t\t''')
                        _v = VFN(VFFSL(SL,"renderEventBlock",True),"render",False)(VFFSL(SL,"event",True)) # u'$renderEventBlock.render($event)' on line 131, col 5
                        if _v is not None: write(_filter(_v, rawExpr=u'$renderEventBlock.render($event)')) # from line 131, col 5.
                        write(u'''
''')
                    if len(VFFSL(SL,"eventlist",True)[VFFSL(SL,"slot",True)]) == 0: # generated from line 133, col 4
                        write(u'''\t\t\t<div class="event"></div>
''')
                    write(u'''\t\t</td>
''')
                write(u'''\t</tr>
''')
            write(u'''</tbody>
<tfoot>
<tr>
''')
            for sname, eventlist in six.iteritems(VFFSL(SL,"events",True)): # generated from line 143, col 2
                write(u'''\t<td class="border"><div class="service ui-widget-header"><img src="''')
                _v = VFFSL(SL,"picons",True)[VFFSL(SL,"sname",True)] # u'$(picons[$sname])' on line 144, col 69
                if _v is not None: write(_filter(_v, rawExpr=u'$(picons[$sname])')) # from line 144, col 69.
                write(u'''" /> ''')
                _v = VFFSL(SL,"sname",True) # u'$sname' on line 144, col 91
                if _v is not None: write(_filter(_v, rawExpr=u'$sname')) # from line 144, col 91.
                write(u'''</div></td>
''')
            write(u'''</tr>
</tfoot>
</table>
''')
        else: # generated from line 149, col 1
            write(u'''<div class="wrapper">
<div id="tbl1body" style="position: relative; width: 100%;">
\t<div id="tblinner" style="height: auto;width: 100%; white-space: nowrap;">
\t<div class="timetable">
\t<div>
\t<div class="timetable-now"></div>
\t</div>
\t</div>

\t<ol id="timescroller" class="channel-listing ui-widget-header nobg" style="border:none;">
\t\t<li>
\t\t\t<span>
\t\t\t\t<div class="togglescroll ui-widget-header">
\t\t\t\t\t<h2 class="picon" ></h2>
\t\t\t\t\t<span></span>
\t\t\t\t</div>
\t\t\t</span>
\t\t\t<ol cass="eventlist">
''')
            pad = 141
            write(u'''\t\t\t\t<li class="event" style="width:''')
            _v = VFFSL(SL,"pad",True) # u'${pad}' on line 169, col 36
            if _v is not None: write(_filter(_v, rawExpr=u'${pad}')) # from line 169, col 36.
            write(u'''px;">
\t\t\t\t</li>
''')
            for slot in list(range(0,50)): # generated from line 171, col 5
                t = VFFSL(SL,"first",True) + (VFFSL(SL,"slot",True) * 3600)
                write(u'''\t\t\t\t\t<li class="event" style="width:600px;" data-dt="''')
                _v = VFFSL(SL,"strftime",False)("%H:%M", VFFSL(SL,"localtime",False)(VFFSL(SL,"t",True))) # u'$strftime("%H:%M", $localtime($t))' on line 173, col 54
                if _v is not None: write(_filter(_v, rawExpr=u'$strftime("%H:%M", $localtime($t))')) # from line 173, col 54.
                write(u'''">
\t\t\t\t\t\t<span class="ui-widget-header nobg">
\t\t\t\t\t\t\t<span class="ename">''')
                _v = VFFSL(SL,"tstrings",True)[("day_" + (VFFSL(SL,"strftime",False)("%w",VFFSL(SL,"localtime",False)(VFFSL(SL,"t",True)))))] # u'$tstrings[("day_" + ($strftime("%w",$localtime($t))))]' on line 175, col 28
                if _v is not None: write(_filter(_v, rawExpr=u'$tstrings[("day_" + ($strftime("%w",$localtime($t))))]')) # from line 175, col 28.
                write(u''', ''')
                _v = VFFSL(SL,"strftime",False)('%d.%m.', VFFSL(SL,"localtime",False)(VFFSL(SL,"t",True))) # u"$strftime('%d.%m.', $localtime($t))" on line 175, col 84
                if _v is not None: write(_filter(_v, rawExpr=u"$strftime('%d.%m.', $localtime($t))")) # from line 175, col 84.
                write(u'''</span>
\t\t\t\t\t\t\t<span class="etime">''')
                _v = VFFSL(SL,"strftime",False)("%H:%M", VFFSL(SL,"localtime",False)(VFFSL(SL,"t",True))) # u'$strftime("%H:%M", $localtime($t))' on line 176, col 28
                if _v is not None: write(_filter(_v, rawExpr=u'$strftime("%H:%M", $localtime($t))')) # from line 176, col 28.
                write(u'''</span>
\t\t\t\t\t\t</span>
\t\t\t\t\t</li>
''')
            write(u'''\t\t\t</ol>
\t\t</li>
\t</ol>

''')
            for sname, eventlist in six.iteritems(VFFSL(SL,"events",True)): # generated from line 184, col 2
                write(u'''\t\t<ol class="channel-listing">
\t\t\t<li>
\t\t\t\t<span class="ui-widget-header">
\t\t\t\t\t<div>
\t\t\t\t\t\t<h2 class="picon" ><img src="''')
                _v = VFFSL(SL,"picons",True)[VFFSL(SL,"sname",True)] # u'$(picons[$sname])' on line 189, col 36
                if _v is not None: write(_filter(_v, rawExpr=u'$(picons[$sname])')) # from line 189, col 36.
                write(u'''" title="''')
                _v = VFFSL(SL,"sname",True) # u'$sname' on line 189, col 62
                if _v is not None: write(_filter(_v, rawExpr=u'$sname')) # from line 189, col 62.
                write(u'''" /></h2>
\t\t\t\t\t\t<span>''')
                _v = VFFSL(SL,"sname",True) # u'$sname' on line 190, col 13
                if _v is not None: write(_filter(_v, rawExpr=u'$sname')) # from line 190, col 13.
                write(u'''</span>
\t\t\t\t\t</div>
\t\t\t\t</span>
\t\t\t\t<ol cass="eventlist">
''')
                c = 0
                ref = ''
                for event in VFFSL(SL,"eventlist",True)[0]: # generated from line 196, col 6
                    pad = 0
                    if VFFSL(SL,"c",True) == 0: # generated from line 198, col 6
                        ref = quote(event['ref'], safe=' ~@#$&()*!+=:;,.?/\'')
                        pad = 141 + (VFFSL(SL,"event.begin_timestamp",True) - VFFSL(SL,"first",True)) / 6
                        write(u'''\t\t\t\t\t\t<li class="event" style=;width:''')
                        _v = VFFSL(SL,"pad",True) # u'${pad}' on line 201, col 38
                        if _v is not None: write(_filter(_v, rawExpr=u'${pad}')) # from line 201, col 38.
                        write(u'''px;">
\t\t\t\t\t\t</li>
''')
                    end = VFFSL(SL,"event.begin_timestamp",True) + VFFSL(SL,"event.duration",True)
                    iscurr = ""
                    if VFFSL(SL,"event.begin_timestamp",True) < VFFSL(SL,"now",True) and VFFSL(SL,"end",True) > VFFSL(SL,"now",True): # generated from line 206, col 6
                        iscurr = " ui-state-hover"
                    if VFFSL(SL,"event",True)['timerStatus'] != '': # generated from line 209, col 6
                        iscurr = " ui-state-hover"
                    write(u'''\t\t\t\t\t<li class="event" data-ref="''')
                    _v = VFFSL(SL,"ref",True) # u'$ref' on line 212, col 34
                    if _v is not None: write(_filter(_v, rawExpr=u'$ref')) # from line 212, col 34.
                    write(u'''" data-id="''')
                    _v = VFFSL(SL,"event.id",True) # u'${event.id}' on line 212, col 49
                    if _v is not None: write(_filter(_v, rawExpr=u'${event.id}')) # from line 212, col 49.
                    write(u'''" style="width:''')
                    _v = VFFSL(SL,"event.duration",True)/6 # u'${event.duration/6}' on line 212, col 75
                    if _v is not None: write(_filter(_v, rawExpr=u'${event.duration/6}')) # from line 212, col 75.
                    write(u'''px;" >
\t\t\t\t\t\t<a href="#" class="ui-widget-content ''')
                    _v = VFFSL(SL,"iscurr",True) # u'${iscurr}' on line 213, col 44
                    if _v is not None: write(_filter(_v, rawExpr=u'${iscurr}')) # from line 213, col 44.
                    write(u'''" title="''')
                    _v = VFFSL(SL,"event",True)['title'] # u"$event['title']" on line 213, col 62
                    if _v is not None: write(_filter(_v, rawExpr=u"$event['title']")) # from line 213, col 62.
                    write(u'''">
\t\t\t\t\t\t<span class="ename">''')
                    _v = VFFSL(SL,"event",True)['title'] # u"$event['title']" on line 214, col 27
                    if _v is not None: write(_filter(_v, rawExpr=u"$event['title']")) # from line 214, col 27.
                    write(u'''</span>
\t\t\t\t\t\t<span class="etime">''')
                    _v = VFFSL(SL,"strftime",False)("%H:%M", VFFSL(SL,"localtime",False)(VFFSL(SL,"event",True)['begin_timestamp'])) # u'$strftime("%H:%M", $localtime($event[\'begin_timestamp\']))' on line 215, col 27
                    if _v is not None: write(_filter(_v, rawExpr=u'$strftime("%H:%M", $localtime($event[\'begin_timestamp\']))')) # from line 215, col 27.
                    write(u'''</span>
''')
                    if VFFSL(SL,"event",True)['timerStatus'] != '': # generated from line 216, col 7
                        tt = VFFSL(SL,"event",True)['timer']['text']
                        write(u'''\t\t\t\t\t\t\t<span class="etimer ''')
                        _v = VFFSL(SL,"event",True)['timerStatus'] # u"$event['timerStatus']" on line 218, col 28
                        if _v is not None: write(_filter(_v, rawExpr=u"$event['timerStatus']")) # from line 218, col 28.
                        write(u'''">''')
                        _v = VFFSL(SL,"tt",True) # u'$tt' on line 218, col 51
                        if _v is not None: write(_filter(_v, rawExpr=u'$tt')) # from line 218, col 51.
                        write(u'''</span>
''')
                    write(u'''\t\t\t\t\t\t</a>
\t\t\t\t\t</li>
''')
                    c = VFFSL(SL,"c",True) + 1
                write(u'''\t\t\t\t</ol>
\t\t\t</li>
\t\t</ol>
''')
            write(u'''</div>
''')
        write(u'''</div>
<div id="eventdescription"></div>

<script>
''')
        if VFFSL(SL,"mode",True) == 2: # generated from line 234, col 1
            write(u'''var opena = ''')
            _v = VFFSL(SL,"first",True) # u'$first' on line 235, col 13
            if _v is not None: write(_filter(_v, rawExpr=u'$first')) # from line 235, col 13.
            write(u''';
var openb = ''')
            _v = VFFSL(SL,"now",True) # u'$now' on line 236, col 13
            if _v is not None: write(_filter(_v, rawExpr=u'$now')) # from line 236, col 13.
            write(u''';
var pos = (openb - opena);
if (pos>0)
\tpos = pos / 6;

''')
            if VFFSL(SL,"day",True) == 0: # generated from line 241, col 1
                write(u'''
$(".timetable-now").css(\'left\',151+pos);

setTimeout(function() {
\tvar nowdate = Math.round(+new Date()/1000);
\tvar pos = (nowdate - opena);
\tif(pos>0)
\t\tpos = pos / 6;
\t$(".timetable-now").css(\'left\',151+pos);
} ,10000);

$(".timetable-now").css(\'height\',$("#tblinner").height());
''')
            else: # generated from line 254, col 1
                write(u'''$(".timetable-now").css(\'height\',\'0\');
''')
            write(u'''
''')
        write(u'''var picons = ''')
        _v = VFFSL(SL,"dumps",False)(VFFSL(SL,"picons",True)) # u'$dumps($picons)' on line 259, col 14
        if _v is not None: write(_filter(_v, rawExpr=u'$dumps($picons)')) # from line 259, col 14.
        write(u''';
var reloadTimers = false;
function getScrollBarWidth () {
\tvar $outer = $(\'<div>\').css({visibility: \'hidden\', width: 100, overflow: \'scroll\'}).appendTo(\'body\'),
\t\twidthWithScroll = $(\'<div>\').css({width: \'100%\'}).appendTo($outer).outerWidth();
\t$outer.remove();
\treturn 100 - widthWithScroll;
}
var scrollBarWidth=getScrollBarWidth();
function fixTableHeight() {
\tvar addScrollBarWidth = scrollBarWidth;
\tif ($(\'#tbl1\').width() <= $("#tvcontent").width()){
\t\taddScrollBarWidth = 0;
\t}
\t
''')
        if VFFSL(SL,"mode",True) == 1: # generated from line 274, col 1
            write(u'''\t$("#tbl1body").height( ($("#tvcontent").height() - $("#navepg").height() - 2*$("#tbl1 thead").height() - addScrollBarWidth - 2) + "px");
''')
        else: # generated from line 276, col 1
            write(u'''\t$("#tbl1body").height( ($("#tvcontent").height() - $("#navepg").height() - 20 - addScrollBarWidth - 2) + "px");
''')
        write(u'''\tif (!$(\'#toolbar-header\').is(\':visible\')) {
\t\tvar dh = $(window).height();
\t\t$("#tvcontentmain").height(dh-80);
\t\t$("#tbl1body").height(dh-215);
\t}
}
fixTableHeight();
$(window).resize(function(){ fixTableHeight(); });
$(".bq").click(function() {
\tvar id = $(this).data("ref");
\tvar epgmode = "''')
        _v = VFFSL(SL,"epgmode",True) # u'$epgmode' on line 289, col 17
        if _v is not None: write(_filter(_v, rawExpr=u'$epgmode')) # from line 289, col 17.
        write(u'''";
\t$("#tvcontent").html(loadspinner).load(\'ajax/multiepg?bref=\'+id +\'&day=''')
        _v = VFFSL(SL,"day",True) # u'$day' on line 290, col 74
        if _v is not None: write(_filter(_v, rawExpr=u'$day')) # from line 290, col 74.
        write(u'''&epgmode=\' + epgmode);
\tSetLSValue("lastmbq_"+epgmode,id);
});
$(".event").click(function() {
\tvar id = $(this).data("id");
\tif (id != undefined) {
\t\tvar ref = $(this).data("ref");
\t\t$("#eventdescription").load(\'ajax/event?idev=\'+id+\'&sref=\'+escape(ref), function() {
\t\t\t$("#eventdescription").show(200).draggable( { handle: ".handle" } );
\t\t});
\t}
});
''')
        if VFFSL(SL,"mode",True) == 1: # generated from line 302, col 1
            write(u'''$(".service").click(function() {
\tvar ref = $(this).data("ref");
\tif (ref != undefined) {
\t\tzapChannel(ref, \'\');
\t}
});
''')
        write(u'''$(".plus").click(function() {
\tvar day = $(this).data("day");
\tvar epgmode = "''')
        _v = VFFSL(SL,"epgmode",True) # u'$epgmode' on line 312, col 17
        if _v is not None: write(_filter(_v, rawExpr=u'$epgmode')) # from line 312, col 17.
        write(u'''";
\tif (day != undefined) {
\t\tif (day > 999)
\t\t{
\t\t\tvar w = day - 1000;
\t\t\t$("#tvcontent").html(loadspinner).load(\'ajax/multiepg?bref=''')
        _v = VFFSL(SL,"quote",False)(VFFSL(SL,"bref",True)) # u'${quote($bref)}' on line 317, col 64
        if _v is not None: write(_filter(_v, rawExpr=u'${quote($bref)}')) # from line 317, col 64.
        write(u"""&day='+""")
        _v = VFFSL(SL,"day",True) # u'$day' on line 317, col 86
        if _v is not None: write(_filter(_v, rawExpr=u'$day')) # from line 317, col 86.
        write(u'''+\'&epgmode=\'+epgmode+\'&week=\'+w);
\t\t}
\t\telse if (day > 199)
\t\t{
\t\t\tvar d = day - 200;
\t\t\tvar dt = (d==0) ? \'\' : $(this).html();
\t\t\tvar pos = 0;
\t\t\t$(\'#tblinner\').scrollLeft(0);
\t\t\t
\t\t\t$("#timescroller li ol .event").each( function (){
\t\t\t\tif (pos == 0) {
\t\t\t\t\tif ($(this).data("dt") == dt) {
\t\t\t\t\t\tif($(this).position() != undefined)
\t\t\t\t\t\t\tpos = $(this).position().left;
\t\t\t\t\t}
\t\t\t\t}
\t\t\t});
\t\t\t
\t\t\tif(d==\'\')
\t\t\t{
\t\t\t\tvar l = $(".timetable-now").css(\'left\');
\t\t\t\tpos = parseInt(l.replace(\'px\',\'\'));
\t\t\t}
\t\t\t
\t\t\tif(pos>0)
\t\t\t{
\t\t\t\tpos-=200;
\t\t\t\t$(\'#tblinner\').animate({scrollLeft: pos}, 500);
\t\t\t}
\t\t}
\t\telse if (day > 100)
\t\t{
\t\t\tvar mode = day - 100;
\t\t\tif (mode != ''')
        _v = VFFSL(SL,"mode",True) # u'$mode' on line 350, col 16
        if _v is not None: write(_filter(_v, rawExpr=u'$mode')) # from line 350, col 16.
        write(u''') {
\t\t\t
\t\t\t\t$.ajax({
\t\t\t\turl: \'api/setwebconfig?mepgmode=\' + mode,
\t\t\t\t\tsuccess: function(data) {
\t\t\t\t\t\t$("#tvcontent").html(loadspinner).load(\'ajax/multiepg?bref=''')
        _v = VFFSL(SL,"quote",False)(VFFSL(SL,"bref",True)) # u'${quote($bref)}' on line 355, col 67
        if _v is not None: write(_filter(_v, rawExpr=u'${quote($bref)}')) # from line 355, col 67.
        write(u'''&day=''')
        _v = VFFSL(SL,"day",True) # u'$day' on line 355, col 87
        if _v is not None: write(_filter(_v, rawExpr=u'$day')) # from line 355, col 87.
        write(u"""&epgmode='+epgmode+'&week='+""")
        _v = VFFSL(SL,"week",True) # u'$week' on line 355, col 119
        if _v is not None: write(_filter(_v, rawExpr=u'$week')) # from line 355, col 119.
        write(u''');
\t\t\t\t\t}
\t\t\t\t});
\t\t\t}
\t\t}
\t\telse {
\t\t\t$("#tvcontent").html(loadspinner).load(\'ajax/multiepg?bref=''')
        _v = VFFSL(SL,"quote",False)(VFFSL(SL,"bref",True)) # u'${quote($bref)}' on line 361, col 64
        if _v is not None: write(_filter(_v, rawExpr=u'${quote($bref)}')) # from line 361, col 64.
        write(u"""&day='+day+'&epgmode='+epgmode+'&week='+""")
        _v = VFFSL(SL,"week",True) # u'$week' on line 361, col 119
        if _v is not None: write(_filter(_v, rawExpr=u'$week')) # from line 361, col 119.
        write(u''');
\t\t}
\t} else {
\t\tepgmode = $(this).data("tvradio");
\t\tif (epgmode != undefined) {
\t\t\t$("#tvcontent").html(loadspinner).load(\'ajax/multiepg?day=\'+day+\'&epgmode=\'+epgmode);
\t\t}
\t}
});
if(!timeredit_initialized)
\t$(\'#editTimerForm\').load(\'/ajax/edittimer\');

if($("#header").is(\':hidden\')) { 
\t$(\'#compressmepg\').show();$(\'#refreshmepg2\').show();
}
if(mepgdirect==1) {
\tmepgdirect=0;$("#expandmepg").click();
}
$(".togglescroll").click(function() {

\tif($(\'#tblinner\').css(\'overflow-y\')==\'hidden\') {
\t\t$(\'#tblinner\').css(\'overflow-y\',\'\');
\t\t$(\'.togglescroll\').removeClass(\'ui-widget-header\');
\t\tSetLSValue(\'MultiEPGScrollStyle\',\'1\');
\t}else{
\t\t$(\'#tblinner\').css(\'overflow-y\',\'hidden\');
\t\t$(\'.togglescroll\').addClass(\'ui-widget-header\');
\t\tSetLSValue(\'MultiEPGScrollStyle\',\'0\');
\t}
});
''')
        if VFFSL(SL,"mode",True) == 2: # generated from line 391, col 1
            write(u"""$(function() {

\tif(GetLSValue('MultiEPGScrollStyle','0')=='0') {
\t\t$('#tblinner').css('overflow-y','hidden');
\t\t$('.togglescroll').addClass('ui-widget-header');
\t}
\telse
\t{
\t\t$('#tblinner').css('overflow-y','');
\t\t$('.togglescroll').removeClass('ui-widget-header');
\t}

});
""")
        write(u'''</script>
''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        
    ##################################################
    ## CHEETAH GENERATED ATTRIBUTES


    _CHEETAH__instanceInitialized = False

    _CHEETAH_version = __CHEETAH_version__

    _CHEETAH_versionTuple = __CHEETAH_versionTuple__

    _CHEETAH_genTime = __CHEETAH_genTime__

    _CHEETAH_genTimestamp = __CHEETAH_genTimestamp__

    _CHEETAH_src = __CHEETAH_src__

    _CHEETAH_srcLastModified = __CHEETAH_srcLastModified__

    _mainCheetahMethod_for_multiepg= 'respond'

## END CLASS DEFINITION

if not hasattr(multiepg, '_initCheetahAttributes'):
    templateAPIClass = getattr(multiepg, '_CHEETAH_templateClass', Template)
    templateAPIClass._addCheetahPlumbingCodeToClass(multiepg)


# CHEETAH was developed by Tavis Rudd and Mike Orr
# with code, advice and input from many other volunteers.
# For more information visit http://www.CheetahTemplate.org/

##################################################
## if run from command line:
if __name__ == '__main__':
    from Cheetah.TemplateCmdLineIface import CmdLineIface
    CmdLineIface(templateObj=multiepg()).run()


