#!/bin/sh

getIfaceName() {
	IFACE=`ls /tmp/bcm/ 2> /dev/null`
	echo ${IFACE:0:5}
}

count=0
while true
do
	IFACE=$(getIfaceName)

	if [ "${IFACE:0:4}" == "wlan" ]; then
		break
	fi

	count=$(($count+1))
	if [ $count == 30 ]; then
		echo "wifi device not found!"
		exit 1
	fi

	if [ `expr $count % 5` -eq 0 ]; then
		echo "IFACE : $IFACE"
		echo "wifi device initializing..."
	fi

	sleep 0.1
done

help() {
	echo "wl-config [OPTIONS]"
	echo "	-h	help"
	echo "	-m ARG	method (None, wep, wpa, wpa2)"
	echo "	-t ARG	key type for wep (ascii or hex)"
	echo "	-k ARG	key"
	exit 0
}

METHOD=None
KEY=XXXXXXXX
SSID=

while getopts "m:t:k:s:h" opt
do
	case $opt in
		m) METHOD=$OPTARG
		 echo "METHOD : $METHOD"
		 ;;
		k) KEY=$OPTARG
		 #echo "KEY : $KEY"
		 ;;
		s) SSID=$OPTARG
		 echo "SSID : $SSID"
		 ;;
		h) help;;
		?) help;;
	esac
done

if [ -z "$SSID" ]; then
	echo "Invalid SSID";
	exit 1
fi

ifconfig $IFACE up
sleep 0.1

wl wowl_clear
wl up
wl auth 2
wl infra 1

case $METHOD in
	None)
		wl wsec 0
		wl wpa_auth 0
		;;
	wep)
		wl wsec 1
		wl wpa_auth 0
		wl addwep 0 "$KEY"
		;;
	wpa)
		wl wsec 6
		wl wpa_auth 4
		wl sup_wpa 1
		wl set_pmk "$KEY"
		;;
	wpa2)
		wl wsec 6
		wl wpa_auth 128
		wl sup_wpa 1
		wl set_pmk "$KEY"
		;;
esac

status() {
	AA=`wl status`
	echo "${AA:0:4}"
}

wl ssid "$SSID"

count=1
while [ $count -le 10 ]
do
   let count=$count+1
   if [ "$(status)" == "SSID" ]; then
      break;
   fi;
   echo "wl-config : waiting..."
   sleep 0.5
done

